<?php

return [
    'dateTimeFormats' => [
        'short' => [
            'date' => 'd.M.yyyy',
            'time' => 'HH:mm',
            'datetime' => 'd.M.yyyy, HH:mm',
        ],
        'medium' => [
            'date' => 'd.M.y',
            'time' => 'HH:mm:ss',
            'datetime' => 'd.M.y, HH:mm:ss',
        ],
        'long' => [
            'date' => 'd. MMMM y',
            'time' => 'HH:mm:ss z',
            'datetime' => 'd. MMMM y \'um\' HH:mm:ss z',
        ],
        'full' => [
            'date' => 'EEEE, d. MMMM y',
            'time' => 'HH:mm:ss zzzz',
            'datetime' => 'EEEE, d. MMMM y \'um\' HH:mm:ss zzzz',
        ],
    ],
    'numberPatterns' => [
        'decimal' => '#,##0.###',
        'currency' => '#,##0.00 ¤',
        'percent' => '#,##0 %',
        'scientific' => '#E0',
    ],
    'amName' => 'vorm.',
    'pmName' => 'nachm.',
    'textAttributes' => [
        'positivePrefix' => '',
        'positiveSuffix' => '',
        'negativePrefix' => '-',
        'negativeSuffix' => '',
        'paddingCharacter' => ' ',
        'currencyCode' => '',
        'defaultRuleset' => '',
        'publicRulesets' => '',
    ],
    'numberSymbols' => [
        'decimalSeparator' => ',',
        'groupingSeparator' => '.',
        'patternSeparator' => ';',
        'percent' => '%',
        'zeroDigit' => '0',
        'digit' => '#',
        'minusSign' => '-',
        'plusSign' => '+',
        'currency' => '¤',
        'intlCurrency' => '¤¤',
        'monetarySeparator' => ',',
        'exponential' => 'E',
        'permill' => '‰',
        'padEscape' => '*',
        'infinity' => '∞',
        'nan' => 'NaN',
        'significantDigit' => '@',
        'monetaryGroupingSeparator' => '.',
    ],
    'currencySymbols' => [
        'AUD' => 'AU$',
        'BRL' => 'R$',
        'CAD' => 'CA$',
        'CNY' => 'CN¥',
        'EUR' => '€',
        'GBP' => '£',
        'HKD' => 'HK$',
        'ILS' => '₪',
        'INR' => '₹',
        'JPY' => '¥',
        'KRW' => '₩',
        'MXN' => 'MX$',
        'NZD' => 'NZ$',
        'THB' => '฿',
        'TWD' => 'NT$',
        'USD' => '$',
        'VND' => '₫',
        'XAF' => 'FCFA',
        'XCD' => 'EC$',
        'XOF' => 'CFA',
        'XPF' => 'CFPF',
    ],
    'standAloneMonthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'Jan',
            'Feb',
            'Mär',
            'Apr',
            'Mai',
            'Jun',
            'Jul',
            'Aug',
            'Sep',
            'Okt',
            'Nov',
            'Dez',
        ],
        'full' => [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember',
        ],
    ],
    'monthNames' => [
        'abbreviated' => [
            'J',
            'F',
            'M',
            'A',
            'M',
            'J',
            'J',
            'A',
            'S',
            'O',
            'N',
            'D',
        ],
        'medium' => [
            'Jan.',
            'Feb.',
            'März',
            'Apr.',
            'Mai',
            'Juni',
            'Juli',
            'Aug.',
            'Sep.',
            'Okt.',
            'Nov.',
            'Dez.',
        ],
        'full' => [
            'Januar',
            'Februar',
            'März',
            'April',
            'Mai',
            'Juni',
            'Juli',
            'August',
            'September',
            'Oktober',
            'November',
            'Dezember',
        ],
    ],
    'standAloneWeekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'D',
            'M',
            'D',
            'F',
            'S',
        ],
        'short' => [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.',
        ],
        'medium' => [
            'So',
            'Mo',
            'Di',
            'Mi',
            'Do',
            'Fr',
            'Sa',
        ],
        'full' => [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag',
        ],
    ],
    'weekDayNames' => [
        'abbreviated' => [
            'S',
            'M',
            'D',
            'M',
            'D',
            'F',
            'S',
        ],
        'short' => [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.',
        ],
        'medium' => [
            'So.',
            'Mo.',
            'Di.',
            'Mi.',
            'Do.',
            'Fr.',
            'Sa.',
        ],
        'full' => [
            'Sonntag',
            'Montag',
            'Dienstag',
            'Mittwoch',
            'Donnerstag',
            'Freitag',
            'Samstag',
        ],
    ],
    'localeDisplayNames' => [
        'af' => 'Afrikaans',
        'af-NA' => 'Afrikaans (Namibia)',
        'af-ZA' => 'Afrikaans (Südafrika)',
        'agq' => 'Aghem',
        'agq-CM' => 'Aghem (Kamerun)',
        'ak' => 'Akan',
        'ak-GH' => 'Akan (Ghana)',
        'am' => 'Amharisch',
        'am-ET' => 'Amharisch (Äthiopien)',
        'ar' => 'Arabisch',
        'ar-001' => 'Arabisch (Welt)',
        'ar-AE' => 'Arabisch (Vereinigte Arabische Emirate)',
        'ar-BH' => 'Arabisch (Bahrain)',
        'ar-DJ' => 'Arabisch (Dschibuti)',
        'ar-DZ' => 'Arabisch (Algerien)',
        'ar-EG' => 'Arabisch (Ägypten)',
        'ar-EH' => 'Arabisch (Westsahara)',
        'ar-ER' => 'Arabisch (Eritrea)',
        'ar-IL' => 'Arabisch (Israel)',
        'ar-IQ' => 'Arabisch (Irak)',
        'ar-JO' => 'Arabisch (Jordanien)',
        'ar-KM' => 'Arabisch (Komoren)',
        'ar-KW' => 'Arabisch (Kuwait)',
        'ar-LB' => 'Arabisch (Libanon)',
        'ar-LY' => 'Arabisch (Libyen)',
        'ar-MA' => 'Arabisch (Marokko)',
        'ar-MR' => 'Arabisch (Mauretanien)',
        'ar-OM' => 'Arabisch (Oman)',
        'ar-PS' => 'Arabisch (Palästinensische Autonomiegebiete)',
        'ar-QA' => 'Arabisch (Katar)',
        'ar-SA' => 'Arabisch (Saudi-Arabien)',
        'ar-SD' => 'Arabisch (Sudan)',
        'ar-SO' => 'Arabisch (Somalia)',
        'ar-SS' => 'Arabisch (Südsudan)',
        'ar-SY' => 'Arabisch (Syrien)',
        'ar-TD' => 'Arabisch (Tschad)',
        'ar-TN' => 'Arabisch (Tunesien)',
        'ar-YE' => 'Arabisch (Jemen)',
        'as' => 'Assamesisch',
        'as-IN' => 'Assamesisch (Indien)',
        'asa' => 'Pare',
        'asa-TZ' => 'Pare (Tansania)',
        'ast' => 'Asturianisch',
        'ast-ES' => 'Asturianisch (Spanien)',
        'az' => 'Aserbaidschanisch',
        'az-Cyrl' => 'Aserbaidschanisch (Kyrillisch)',
        'az-Cyrl-AZ' => 'Aserbaidschanisch (Kyrillisch, Aserbaidschan)',
        'az-Latn' => 'Aserbaidschanisch (Lateinisch)',
        'az-Latn-AZ' => 'Aserbaidschanisch (Lateinisch, Aserbaidschan)',
        'bas' => 'Basaa-Sprache',
        'bas-CM' => 'Basaa-Sprache (Kamerun)',
        'be' => 'Weißrussisch',
        'be-BY' => 'Weißrussisch (Belarus)',
        'bem' => 'Bemba',
        'bem-ZM' => 'Bemba (Sambia)',
        'bez' => 'Bena',
        'bez-TZ' => 'Bena (Tansania)',
        'bg' => 'Bulgarisch',
        'bg-BG' => 'Bulgarisch (Bulgarien)',
        'bm' => 'Bambara',
        'bm-ML' => 'Bambara (Mali)',
        'bn' => 'Bengalisch',
        'bn-BD' => 'Bengalisch (Bangladesch)',
        'bn-IN' => 'Bengalisch (Indien)',
        'bo' => 'Tibetisch',
        'bo-CN' => 'Tibetisch (China)',
        'bo-IN' => 'Tibetisch (Indien)',
        'br' => 'Bretonisch',
        'br-FR' => 'Bretonisch (Frankreich)',
        'brx' => 'Bodo',
        'brx-IN' => 'Bodo (Indien)',
        'bs' => 'Bosnisch',
        'bs-Cyrl' => 'Bosnisch (Kyrillisch)',
        'bs-Cyrl-BA' => 'Bosnisch (Kyrillisch, Bosnien und Herzegowina)',
        'bs-Latn' => 'Bosnisch (Lateinisch)',
        'bs-Latn-BA' => 'Bosnisch (Lateinisch, Bosnien und Herzegowina)',
        'ca' => 'Katalanisch',
        'ca-AD' => 'Katalanisch (Andorra)',
        'ca-ES' => 'Katalanisch (Spanien)',
        'ca-FR' => 'Katalanisch (Frankreich)',
        'ca-IT' => 'Katalanisch (Italien)',
        'ce' => 'Tschetschenisch',
        'ce-RU' => 'Tschetschenisch (Russland)',
        'cgg' => 'Rukiga',
        'cgg-UG' => 'Rukiga (Uganda)',
        'chr' => 'Cherokee',
        'chr-US' => 'Cherokee (Vereinigte Staaten)',
        'cs' => 'Tschechisch',
        'cs-CZ' => 'Tschechisch (Tschechische Republik)',
        'cy' => 'Walisisch',
        'cy-GB' => 'Walisisch (Vereinigtes Königreich)',
        'da' => 'Dänisch',
        'da-DK' => 'Dänisch (Dänemark)',
        'da-GL' => 'Dänisch (Grönland)',
        'dav' => 'Taita',
        'dav-KE' => 'Taita (Kenia)',
        'de' => 'Deutsch',
        'de-AT' => 'Deutsch (Österreich)',
        'de-BE' => 'Deutsch (Belgien)',
        'de-CH' => 'Deutsch (Schweiz)',
        'de-DE' => 'Deutsch (Deutschland)',
        'de-LI' => 'Deutsch (Liechtenstein)',
        'de-LU' => 'Deutsch (Luxemburg)',
        'dje' => 'Zarma',
        'dje-NE' => 'Zarma (Niger)',
        'dsb' => 'Niedersorbisch',
        'dsb-DE' => 'Niedersorbisch (Deutschland)',
        'dua' => 'Duala',
        'dua-CM' => 'Duala (Kamerun)',
        'dyo' => 'Diola',
        'dyo-SN' => 'Diola (Senegal)',
        'dz' => 'Dzongkha',
        'dz-BT' => 'Dzongkha (Bhutan)',
        'ebu' => 'Embu',
        'ebu-KE' => 'Embu (Kenia)',
        'ee' => 'Ewe',
        'ee-GH' => 'Ewe (Ghana)',
        'ee-TG' => 'Ewe (Togo)',
        'el' => 'Griechisch',
        'el-CY' => 'Griechisch (Zypern)',
        'el-GR' => 'Griechisch (Griechenland)',
        'en' => 'Englisch',
        'en-001' => 'Englisch (Welt)',
        'en-150' => 'Englisch (Europa)',
        'en-AG' => 'Englisch (Antigua und Barbuda)',
        'en-AI' => 'Englisch (Anguilla)',
        'en-AS' => 'Englisch (Amerikanisch-Samoa)',
        'en-AT' => 'Englisch (Österreich)',
        'en-AU' => 'Englisch (Australien)',
        'en-BB' => 'Englisch (Barbados)',
        'en-BE' => 'Englisch (Belgien)',
        'en-BI' => 'Englisch (Burundi)',
        'en-BM' => 'Englisch (Bermuda)',
        'en-BS' => 'Englisch (Bahamas)',
        'en-BW' => 'Englisch (Botsuana)',
        'en-BZ' => 'Englisch (Belize)',
        'en-CA' => 'Englisch (Kanada)',
        'en-CC' => 'Englisch (Kokosinseln)',
        'en-CH' => 'Englisch (Schweiz)',
        'en-CK' => 'Englisch (Cookinseln)',
        'en-CM' => 'Englisch (Kamerun)',
        'en-CX' => 'Englisch (Weihnachtsinsel)',
        'en-CY' => 'Englisch (Zypern)',
        'en-DE' => 'Englisch (Deutschland)',
        'en-DG' => 'Englisch (Diego Garcia)',
        'en-DK' => 'Englisch (Dänemark)',
        'en-DM' => 'Englisch (Dominica)',
        'en-ER' => 'Englisch (Eritrea)',
        'en-FI' => 'Englisch (Finnland)',
        'en-FJ' => 'Englisch (Fidschi)',
        'en-FK' => 'Englisch (Falklandinseln)',
        'en-FM' => 'Englisch (Mikronesien)',
        'en-GB' => 'Englisch (Vereinigtes Königreich)',
        'en-GD' => 'Englisch (Grenada)',
        'en-GG' => 'Englisch (Guernsey)',
        'en-GH' => 'Englisch (Ghana)',
        'en-GI' => 'Englisch (Gibraltar)',
        'en-GM' => 'Englisch (Gambia)',
        'en-GU' => 'Englisch (Guam)',
        'en-GY' => 'Englisch (Guyana)',
        'en-HK' => 'Englisch (Sonderverwaltungszone Hongkong)',
        'en-IE' => 'Englisch (Irland)',
        'en-IL' => 'Englisch (Israel)',
        'en-IM' => 'Englisch (Isle of Man)',
        'en-IN' => 'Englisch (Indien)',
        'en-IO' => 'Englisch (Britisches Territorium im Indischen Ozean)',
        'en-JE' => 'Englisch (Jersey)',
        'en-JM' => 'Englisch (Jamaika)',
        'en-KE' => 'Englisch (Kenia)',
        'en-KI' => 'Englisch (Kiribati)',
        'en-KN' => 'Englisch (St. Kitts und Nevis)',
        'en-KY' => 'Englisch (Kaimaninseln)',
        'en-LC' => 'Englisch (St. Lucia)',
        'en-LR' => 'Englisch (Liberia)',
        'en-LS' => 'Englisch (Lesotho)',
        'en-MG' => 'Englisch (Madagaskar)',
        'en-MH' => 'Englisch (Marshallinseln)',
        'en-MO' => 'Englisch (Sonderverwaltungsregion Macau)',
        'en-MP' => 'Englisch (Nördliche Marianen)',
        'en-MS' => 'Englisch (Montserrat)',
        'en-MT' => 'Englisch (Malta)',
        'en-MU' => 'Englisch (Mauritius)',
        'en-MW' => 'Englisch (Malawi)',
        'en-MY' => 'Englisch (Malaysia)',
        'en-NA' => 'Englisch (Namibia)',
        'en-NF' => 'Englisch (Norfolkinsel)',
        'en-NG' => 'Englisch (Nigeria)',
        'en-NL' => 'Englisch (Niederlande)',
        'en-NR' => 'Englisch (Nauru)',
        'en-NU' => 'Englisch (Niue)',
        'en-NZ' => 'Englisch (Neuseeland)',
        'en-PG' => 'Englisch (Papua-Neuguinea)',
        'en-PH' => 'Englisch (Philippinen)',
        'en-PK' => 'Englisch (Pakistan)',
        'en-PN' => 'Englisch (Pitcairninseln)',
        'en-PR' => 'Englisch (Puerto Rico)',
        'en-PW' => 'Englisch (Palau)',
        'en-RW' => 'Englisch (Ruanda)',
        'en-SB' => 'Englisch (Salomonen)',
        'en-SC' => 'Englisch (Seychellen)',
        'en-SD' => 'Englisch (Sudan)',
        'en-SE' => 'Englisch (Schweden)',
        'en-SG' => 'Englisch (Singapur)',
        'en-SH' => 'Englisch (St. Helena)',
        'en-SI' => 'Englisch (Slowenien)',
        'en-SL' => 'Englisch (Sierra Leone)',
        'en-SS' => 'Englisch (Südsudan)',
        'en-SX' => 'Englisch (Sint Maarten)',
        'en-SZ' => 'Englisch (Swasiland)',
        'en-TC' => 'Englisch (Turks- und Caicosinseln)',
        'en-TK' => 'Englisch (Tokelau)',
        'en-TO' => 'Englisch (Tonga)',
        'en-TT' => 'Englisch (Trinidad und Tobago)',
        'en-TV' => 'Englisch (Tuvalu)',
        'en-TZ' => 'Englisch (Tansania)',
        'en-UG' => 'Englisch (Uganda)',
        'en-UM' => 'Englisch (Amerikanische Überseeinseln)',
        'en-US' => 'Englisch (Vereinigte Staaten)',
        'en-US-POSIX' => 'Englisch (Vereinigte Staaten, Posix)',
        'en-VC' => 'Englisch (St. Vincent und die Grenadinen)',
        'en-VG' => 'Englisch (Britische Jungferninseln)',
        'en-VI' => 'Englisch (Amerikanische Jungferninseln)',
        'en-VU' => 'Englisch (Vanuatu)',
        'en-WS' => 'Englisch (Samoa)',
        'en-ZA' => 'Englisch (Südafrika)',
        'en-ZM' => 'Englisch (Sambia)',
        'en-ZW' => 'Englisch (Simbabwe)',
        'eo' => 'Esperanto',
        'es' => 'Spanisch',
        'es-419' => 'Spanisch (Lateinamerika)',
        'es-AR' => 'Spanisch (Argentinien)',
        'es-BO' => 'Spanisch (Bolivien)',
        'es-CL' => 'Spanisch (Chile)',
        'es-CO' => 'Spanisch (Kolumbien)',
        'es-CR' => 'Spanisch (Costa Rica)',
        'es-CU' => 'Spanisch (Kuba)',
        'es-DO' => 'Spanisch (Dominikanische Republik)',
        'es-EA' => 'Spanisch (Ceuta und Melilla)',
        'es-EC' => 'Spanisch (Ecuador)',
        'es-ES' => 'Spanisch (Spanien)',
        'es-GQ' => 'Spanisch (Äquatorialguinea)',
        'es-GT' => 'Spanisch (Guatemala)',
        'es-HN' => 'Spanisch (Honduras)',
        'es-IC' => 'Spanisch (Kanarische Inseln)',
        'es-MX' => 'Spanisch (Mexiko)',
        'es-NI' => 'Spanisch (Nicaragua)',
        'es-PA' => 'Spanisch (Panama)',
        'es-PE' => 'Spanisch (Peru)',
        'es-PH' => 'Spanisch (Philippinen)',
        'es-PR' => 'Spanisch (Puerto Rico)',
        'es-PY' => 'Spanisch (Paraguay)',
        'es-SV' => 'Spanisch (El Salvador)',
        'es-US' => 'Spanisch (Vereinigte Staaten)',
        'es-UY' => 'Spanisch (Uruguay)',
        'es-VE' => 'Spanisch (Venezuela)',
        'et' => 'Estnisch',
        'et-EE' => 'Estnisch (Estland)',
        'eu' => 'Baskisch',
        'eu-ES' => 'Baskisch (Spanien)',
        'ewo' => 'Ewondo',
        'ewo-CM' => 'Ewondo (Kamerun)',
        'fa' => 'Persisch',
        'fa-AF' => 'Persisch (Afghanistan)',
        'fa-IR' => 'Persisch (Iran)',
        'ff' => 'Ful',
        'ff-CM' => 'Ful (Kamerun)',
        'ff-GN' => 'Ful (Guinea)',
        'ff-MR' => 'Ful (Mauretanien)',
        'ff-SN' => 'Ful (Senegal)',
        'fi' => 'Finnisch',
        'fi-FI' => 'Finnisch (Finnland)',
        'fil' => 'Filipino',
        'fil-PH' => 'Filipino (Philippinen)',
        'fo' => 'Färöisch',
        'fo-DK' => 'Färöisch (Dänemark)',
        'fo-FO' => 'Färöisch (Färöer)',
        'fr' => 'Französisch',
        'fr-BE' => 'Französisch (Belgien)',
        'fr-BF' => 'Französisch (Burkina Faso)',
        'fr-BI' => 'Französisch (Burundi)',
        'fr-BJ' => 'Französisch (Benin)',
        'fr-BL' => 'Französisch (St. Barthélemy)',
        'fr-CA' => 'Französisch (Kanada)',
        'fr-CD' => 'Französisch (Kongo-Kinshasa)',
        'fr-CF' => 'Französisch (Zentralafrikanische Republik)',
        'fr-CG' => 'Französisch (Kongo-Brazzaville)',
        'fr-CH' => 'Französisch (Schweiz)',
        'fr-CI' => 'Französisch (Côte d’Ivoire)',
        'fr-CM' => 'Französisch (Kamerun)',
        'fr-DJ' => 'Französisch (Dschibuti)',
        'fr-DZ' => 'Französisch (Algerien)',
        'fr-FR' => 'Französisch (Frankreich)',
        'fr-GA' => 'Französisch (Gabun)',
        'fr-GF' => 'Französisch (Französisch-Guayana)',
        'fr-GN' => 'Französisch (Guinea)',
        'fr-GP' => 'Französisch (Guadeloupe)',
        'fr-GQ' => 'Französisch (Äquatorialguinea)',
        'fr-HT' => 'Französisch (Haiti)',
        'fr-KM' => 'Französisch (Komoren)',
        'fr-LU' => 'Französisch (Luxemburg)',
        'fr-MA' => 'Französisch (Marokko)',
        'fr-MC' => 'Französisch (Monaco)',
        'fr-MF' => 'Französisch (St. Martin)',
        'fr-MG' => 'Französisch (Madagaskar)',
        'fr-ML' => 'Französisch (Mali)',
        'fr-MQ' => 'Französisch (Martinique)',
        'fr-MR' => 'Französisch (Mauretanien)',
        'fr-MU' => 'Französisch (Mauritius)',
        'fr-NC' => 'Französisch (Neukaledonien)',
        'fr-NE' => 'Französisch (Niger)',
        'fr-PF' => 'Französisch (Französisch-Polynesien)',
        'fr-PM' => 'Französisch (St. Pierre und Miquelon)',
        'fr-RE' => 'Französisch (Réunion)',
        'fr-RW' => 'Französisch (Ruanda)',
        'fr-SC' => 'Französisch (Seychellen)',
        'fr-SN' => 'Französisch (Senegal)',
        'fr-SY' => 'Französisch (Syrien)',
        'fr-TD' => 'Französisch (Tschad)',
        'fr-TG' => 'Französisch (Togo)',
        'fr-TN' => 'Französisch (Tunesien)',
        'fr-VU' => 'Französisch (Vanuatu)',
        'fr-WF' => 'Französisch (Wallis und Futuna)',
        'fr-YT' => 'Französisch (Mayotte)',
        'fur' => 'Friulisch',
        'fur-IT' => 'Friulisch (Italien)',
        'fy' => 'Westfriesisch',
        'fy-NL' => 'Westfriesisch (Niederlande)',
        'ga' => 'Irisch',
        'ga-IE' => 'Irisch (Irland)',
        'gd' => 'Schottisches Gälisch',
        'gd-GB' => 'Schottisches Gälisch (Vereinigtes Königreich)',
        'gl' => 'Galizisch',
        'gl-ES' => 'Galizisch (Spanien)',
        'gsw' => 'Schweizerdeutsch',
        'gsw-CH' => 'Schweizerdeutsch (Schweiz)',
        'gsw-FR' => 'Schweizerdeutsch (Frankreich)',
        'gsw-LI' => 'Schweizerdeutsch (Liechtenstein)',
        'gu' => 'Gujarati',
        'gu-IN' => 'Gujarati (Indien)',
        'guz' => 'Gusii',
        'guz-KE' => 'Gusii (Kenia)',
        'gv' => 'Manx',
        'gv-IM' => 'Manx (Isle of Man)',
        'ha' => 'Haussa',
        'ha-GH' => 'Haussa (Ghana)',
        'ha-NE' => 'Haussa (Niger)',
        'ha-NG' => 'Haussa (Nigeria)',
        'haw' => 'Hawaiisch',
        'haw-US' => 'Hawaiisch (Vereinigte Staaten)',
        'he' => 'Hebräisch',
        'he-IL' => 'Hebräisch (Israel)',
        'hi' => 'Hindi',
        'hi-IN' => 'Hindi (Indien)',
        'hr' => 'Kroatisch',
        'hr-BA' => 'Kroatisch (Bosnien und Herzegowina)',
        'hr-HR' => 'Kroatisch (Kroatien)',
        'hsb' => 'Obersorbisch',
        'hsb-DE' => 'Obersorbisch (Deutschland)',
        'hu' => 'Ungarisch',
        'hu-HU' => 'Ungarisch (Ungarn)',
        'hy' => 'Armenisch',
        'hy-AM' => 'Armenisch (Armenien)',
        'id' => 'Indonesisch',
        'id-ID' => 'Indonesisch (Indonesien)',
        'ig' => 'Igbo',
        'ig-NG' => 'Igbo (Nigeria)',
        'ii' => 'Yi',
        'ii-CN' => 'Yi (China)',
        'is' => 'Isländisch',
        'is-IS' => 'Isländisch (Island)',
        'it' => 'Italienisch',
        'it-CH' => 'Italienisch (Schweiz)',
        'it-IT' => 'Italienisch (Italien)',
        'it-SM' => 'Italienisch (San Marino)',
        'ja' => 'Japanisch',
        'ja-JP' => 'Japanisch (Japan)',
        'jgo' => 'Ngomba',
        'jgo-CM' => 'Ngomba (Kamerun)',
        'jmc' => 'Machame',
        'jmc-TZ' => 'Machame (Tansania)',
        'ka' => 'Georgisch',
        'ka-GE' => 'Georgisch (Georgien)',
        'kab' => 'Kabylisch',
        'kab-DZ' => 'Kabylisch (Algerien)',
        'kam' => 'Kamba',
        'kam-KE' => 'Kamba (Kenia)',
        'kde' => 'Makonde',
        'kde-TZ' => 'Makonde (Tansania)',
        'kea' => 'Kabuverdianu',
        'kea-CV' => 'Kabuverdianu (Kap Verde)',
        'khq' => 'Koyra Chiini',
        'khq-ML' => 'Koyra Chiini (Mali)',
        'ki' => 'Kikuyu',
        'ki-KE' => 'Kikuyu (Kenia)',
        'kk' => 'Kasachisch',
        'kk-KZ' => 'Kasachisch (Kasachstan)',
        'kkj' => 'Kako',
        'kkj-CM' => 'Kako (Kamerun)',
        'kl' => 'Grönländisch',
        'kl-GL' => 'Grönländisch (Grönland)',
        'kln' => 'Kalenjin',
        'kln-KE' => 'Kalenjin (Kenia)',
        'km' => 'Khmer',
        'km-KH' => 'Khmer (Kambodscha)',
        'kn' => 'Kannada',
        'kn-IN' => 'Kannada (Indien)',
        'ko' => 'Koreanisch',
        'ko-KP' => 'Koreanisch (Nordkorea)',
        'ko-KR' => 'Koreanisch (Südkorea)',
        'kok' => 'Konkani',
        'kok-IN' => 'Konkani (Indien)',
        'ks' => 'Kaschmiri',
        'ks-IN' => 'Kaschmiri (Indien)',
        'ksb' => 'Shambala',
        'ksb-TZ' => 'Shambala (Tansania)',
        'ksf' => 'Bafia',
        'ksf-CM' => 'Bafia (Kamerun)',
        'ksh' => 'Kölsch',
        'ksh-DE' => 'Kölsch (Deutschland)',
        'kw' => 'Kornisch',
        'kw-GB' => 'Kornisch (Vereinigtes Königreich)',
        'ky' => 'Kirgisisch',
        'ky-KG' => 'Kirgisisch (Kirgisistan)',
        'lag' => 'Langi',
        'lag-TZ' => 'Langi (Tansania)',
        'lb' => 'Luxemburgisch',
        'lb-LU' => 'Luxemburgisch (Luxemburg)',
        'lg' => 'Ganda',
        'lg-UG' => 'Ganda (Uganda)',
        'lkt' => 'Lakota',
        'lkt-US' => 'Lakota (Vereinigte Staaten)',
        'ln' => 'Lingala',
        'ln-AO' => 'Lingala (Angola)',
        'ln-CD' => 'Lingala (Kongo-Kinshasa)',
        'ln-CF' => 'Lingala (Zentralafrikanische Republik)',
        'ln-CG' => 'Lingala (Kongo-Brazzaville)',
        'lo' => 'Laotisch',
        'lo-LA' => 'Laotisch (Laos)',
        'lrc' => 'Nördliches Luri',
        'lrc-IQ' => 'Nördliches Luri (Irak)',
        'lrc-IR' => 'Nördliches Luri (Iran)',
        'lt' => 'Litauisch',
        'lt-LT' => 'Litauisch (Litauen)',
        'lu' => 'Luba-Katanga',
        'lu-CD' => 'Luba-Katanga (Kongo-Kinshasa)',
        'luo' => 'Luo-Sprache',
        'luo-KE' => 'Luo-Sprache (Kenia)',
        'luy' => 'Luhya',
        'luy-KE' => 'Luhya (Kenia)',
        'lv' => 'Lettisch',
        'lv-LV' => 'Lettisch (Lettland)',
        'mas' => 'Massai',
        'mas-KE' => 'Massai (Kenia)',
        'mas-TZ' => 'Massai (Tansania)',
        'mer' => 'Meru',
        'mer-KE' => 'Meru (Kenia)',
        'mfe' => 'Morisyen',
        'mfe-MU' => 'Morisyen (Mauritius)',
        'mg' => 'Madagassisch',
        'mg-MG' => 'Madagassisch (Madagaskar)',
        'mgh' => 'Makhuwa-Meetto',
        'mgh-MZ' => 'Makhuwa-Meetto (Mosambik)',
        'mgo' => 'Meta’',
        'mgo-CM' => 'Meta’ (Kamerun)',
        'mk' => 'Mazedonisch',
        'mk-MK' => 'Mazedonisch (Mazedonien)',
        'ml' => 'Malayalam',
        'ml-IN' => 'Malayalam (Indien)',
        'mn' => 'Mongolisch',
        'mn-MN' => 'Mongolisch (Mongolei)',
        'mr' => 'Marathi',
        'mr-IN' => 'Marathi (Indien)',
        'ms' => 'Malaiisch',
        'ms-BN' => 'Malaiisch (Brunei Darussalam)',
        'ms-MY' => 'Malaiisch (Malaysia)',
        'ms-SG' => 'Malaiisch (Singapur)',
        'mt' => 'Maltesisch',
        'mt-MT' => 'Maltesisch (Malta)',
        'mua' => 'Mundang',
        'mua-CM' => 'Mundang (Kamerun)',
        'my' => 'Birmanisch',
        'my-MM' => 'Birmanisch (Myanmar)',
        'mzn' => 'Masanderanisch',
        'mzn-IR' => 'Masanderanisch (Iran)',
        'naq' => 'Nama',
        'naq-NA' => 'Nama (Namibia)',
        'nb' => 'Norwegisch Bokmål',
        'nb-NO' => 'Norwegisch Bokmål (Norwegen)',
        'nb-SJ' => 'Norwegisch Bokmål (Svalbard und Jan Mayen)',
        'nd' => 'Nord-Ndebele',
        'nd-ZW' => 'Nord-Ndebele (Simbabwe)',
        'ne' => 'Nepalesisch',
        'ne-IN' => 'Nepalesisch (Indien)',
        'ne-NP' => 'Nepalesisch (Nepal)',
        'nl' => 'Niederländisch',
        'nl-AW' => 'Niederländisch (Aruba)',
        'nl-BE' => 'Niederländisch (Belgien)',
        'nl-BQ' => 'Niederländisch (Bonaire, Sint Eustatius und Saba)',
        'nl-CW' => 'Niederländisch (Curaçao)',
        'nl-NL' => 'Niederländisch (Niederlande)',
        'nl-SR' => 'Niederländisch (Suriname)',
        'nl-SX' => 'Niederländisch (Sint Maarten)',
        'nmg' => 'Kwasio',
        'nmg-CM' => 'Kwasio (Kamerun)',
        'nn' => 'Norwegisch Nynorsk',
        'nn-NO' => 'Norwegisch Nynorsk (Norwegen)',
        'nnh' => 'Ngiemboon',
        'nnh-CM' => 'Ngiemboon (Kamerun)',
        'nus' => 'Nuer',
        'nus-SS' => 'Nuer (Südsudan)',
        'nyn' => 'Nyankole',
        'nyn-UG' => 'Nyankole (Uganda)',
        'om' => 'Oromo',
        'om-ET' => 'Oromo (Äthiopien)',
        'om-KE' => 'Oromo (Kenia)',
        'or' => 'Oriya',
        'or-IN' => 'Oriya (Indien)',
        'os' => 'Ossetisch',
        'os-GE' => 'Ossetisch (Georgien)',
        'os-RU' => 'Ossetisch (Russland)',
        'pa' => 'Punjabi',
        'pa-Arab' => 'Punjabi (Arabisch)',
        'pa-Arab-PK' => 'Punjabi (Arabisch, Pakistan)',
        'pa-Guru' => 'Punjabi (Gurmukhi)',
        'pa-Guru-IN' => 'Punjabi (Gurmukhi, Indien)',
        'pl' => 'Polnisch',
        'pl-PL' => 'Polnisch (Polen)',
        'ps' => 'Paschtu',
        'ps-AF' => 'Paschtu (Afghanistan)',
        'pt' => 'Portugiesisch',
        'pt-AO' => 'Portugiesisch (Angola)',
        'pt-BR' => 'Portugiesisch (Brasilien)',
        'pt-CV' => 'Portugiesisch (Kap Verde)',
        'pt-GW' => 'Portugiesisch (Guinea-Bissau)',
        'pt-MO' => 'Portugiesisch (Sonderverwaltungsregion Macau)',
        'pt-MZ' => 'Portugiesisch (Mosambik)',
        'pt-PT' => 'Portugiesisch (Portugal)',
        'pt-ST' => 'Portugiesisch (São Tomé und Príncipe)',
        'pt-TL' => 'Portugiesisch (Timor-Leste)',
        'qu' => 'Quechua',
        'qu-BO' => 'Quechua (Bolivien)',
        'qu-EC' => 'Quechua (Ecuador)',
        'qu-PE' => 'Quechua (Peru)',
        'rm' => 'Rätoromanisch',
        'rm-CH' => 'Rätoromanisch (Schweiz)',
        'rn' => 'Rundi',
        'rn-BI' => 'Rundi (Burundi)',
        'ro' => 'Rumänisch',
        'ro-MD' => 'Rumänisch (Republik Moldau)',
        'ro-RO' => 'Rumänisch (Rumänien)',
        'rof' => 'Rombo',
        'rof-TZ' => 'Rombo (Tansania)',
        'ru' => 'Russisch',
        'ru-BY' => 'Russisch (Belarus)',
        'ru-KG' => 'Russisch (Kirgisistan)',
        'ru-KZ' => 'Russisch (Kasachstan)',
        'ru-MD' => 'Russisch (Republik Moldau)',
        'ru-RU' => 'Russisch (Russland)',
        'ru-UA' => 'Russisch (Ukraine)',
        'rw' => 'Kinyarwanda',
        'rw-RW' => 'Kinyarwanda (Ruanda)',
        'rwk' => 'Rwa',
        'rwk-TZ' => 'Rwa (Tansania)',
        'sah' => 'Jakutisch',
        'sah-RU' => 'Jakutisch (Russland)',
        'saq' => 'Samburu',
        'saq-KE' => 'Samburu (Kenia)',
        'sbp' => 'Sangu',
        'sbp-TZ' => 'Sangu (Tansania)',
        'se' => 'Nordsamisch',
        'se-FI' => 'Nordsamisch (Finnland)',
        'se-NO' => 'Nordsamisch (Norwegen)',
        'se-SE' => 'Nordsamisch (Schweden)',
        'seh' => 'Sena',
        'seh-MZ' => 'Sena (Mosambik)',
        'ses' => 'Koyra Senni',
        'ses-ML' => 'Koyra Senni (Mali)',
        'sg' => 'Sango',
        'sg-CF' => 'Sango (Zentralafrikanische Republik)',
        'shi' => 'Taschelhit',
        'shi-Latn' => 'Taschelhit (Lateinisch)',
        'shi-Latn-MA' => 'Taschelhit (Lateinisch, Marokko)',
        'shi-Tfng' => 'Taschelhit (Tifinagh)',
        'shi-Tfng-MA' => 'Taschelhit (Tifinagh, Marokko)',
        'si' => 'Singhalesisch',
        'si-LK' => 'Singhalesisch (Sri Lanka)',
        'sk' => 'Slowakisch',
        'sk-SK' => 'Slowakisch (Slowakei)',
        'sl' => 'Slowenisch',
        'sl-SI' => 'Slowenisch (Slowenien)',
        'smn' => 'Inari-Samisch',
        'smn-FI' => 'Inari-Samisch (Finnland)',
        'sn' => 'Shona',
        'sn-ZW' => 'Shona (Simbabwe)',
        'so' => 'Somali',
        'so-DJ' => 'Somali (Dschibuti)',
        'so-ET' => 'Somali (Äthiopien)',
        'so-KE' => 'Somali (Kenia)',
        'so-SO' => 'Somali (Somalia)',
        'sq' => 'Albanisch',
        'sq-AL' => 'Albanisch (Albanien)',
        'sq-MK' => 'Albanisch (Mazedonien)',
        'sq-XK' => 'Albanisch (Kosovo)',
        'sr' => 'Serbisch',
        'sr-Cyrl' => 'Serbisch (Kyrillisch)',
        'sr-Cyrl-BA' => 'Serbisch (Kyrillisch, Bosnien und Herzegowina)',
        'sr-Cyrl-ME' => 'Serbisch (Kyrillisch, Montenegro)',
        'sr-Cyrl-RS' => 'Serbisch (Kyrillisch, Serbien)',
        'sr-Cyrl-XK' => 'Serbisch (Kyrillisch, Kosovo)',
        'sr-Latn' => 'Serbisch (Lateinisch)',
        'sr-Latn-BA' => 'Serbisch (Lateinisch, Bosnien und Herzegowina)',
        'sr-Latn-ME' => 'Serbisch (Lateinisch, Montenegro)',
        'sr-Latn-RS' => 'Serbisch (Lateinisch, Serbien)',
        'sr-Latn-XK' => 'Serbisch (Lateinisch, Kosovo)',
        'sv' => 'Schwedisch',
        'sv-AX' => 'Schwedisch (Ålandinseln)',
        'sv-FI' => 'Schwedisch (Finnland)',
        'sv-SE' => 'Schwedisch (Schweden)',
        'sw' => 'Suaheli',
        'sw-CD' => 'Suaheli (Kongo-Kinshasa)',
        'sw-KE' => 'Suaheli (Kenia)',
        'sw-TZ' => 'Suaheli (Tansania)',
        'sw-UG' => 'Suaheli (Uganda)',
        'ta' => 'Tamil',
        'ta-IN' => 'Tamil (Indien)',
        'ta-LK' => 'Tamil (Sri Lanka)',
        'ta-MY' => 'Tamil (Malaysia)',
        'ta-SG' => 'Tamil (Singapur)',
        'te' => 'Telugu',
        'te-IN' => 'Telugu (Indien)',
        'teo' => 'Teso',
        'teo-KE' => 'Teso (Kenia)',
        'teo-UG' => 'Teso (Uganda)',
        'th' => 'Thailändisch',
        'th-TH' => 'Thailändisch (Thailand)',
        'ti' => 'Tigrinya',
        'ti-ER' => 'Tigrinya (Eritrea)',
        'ti-ET' => 'Tigrinya (Äthiopien)',
        'to' => 'Tongaisch',
        'to-TO' => 'Tongaisch (Tonga)',
        'tr' => 'Türkisch',
        'tr-CY' => 'Türkisch (Zypern)',
        'tr-TR' => 'Türkisch (Türkei)',
        'twq' => 'Tasawaq',
        'twq-NE' => 'Tasawaq (Niger)',
        'tzm' => 'Zentralatlas-Tamazight',
        'tzm-MA' => 'Zentralatlas-Tamazight (Marokko)',
        'ug' => 'Uigurisch',
        'ug-CN' => 'Uigurisch (China)',
        'uk' => 'Ukrainisch',
        'uk-UA' => 'Ukrainisch (Ukraine)',
        'ur' => 'Urdu',
        'ur-IN' => 'Urdu (Indien)',
        'ur-PK' => 'Urdu (Pakistan)',
        'uz' => 'Usbekisch',
        'uz-Arab' => 'Usbekisch (Arabisch)',
        'uz-Arab-AF' => 'Usbekisch (Arabisch, Afghanistan)',
        'uz-Cyrl' => 'Usbekisch (Kyrillisch)',
        'uz-Cyrl-UZ' => 'Usbekisch (Kyrillisch, Usbekistan)',
        'uz-Latn' => 'Usbekisch (Lateinisch)',
        'uz-Latn-UZ' => 'Usbekisch (Lateinisch, Usbekistan)',
        'vai' => 'Vai',
        'vai-Latn' => 'Vai (Lateinisch)',
        'vai-Latn-LR' => 'Vai (Lateinisch, Liberia)',
        'vai-Vaii' => 'Vai (Vai)',
        'vai-Vaii-LR' => 'Vai (Vai, Liberia)',
        'vi' => 'Vietnamesisch',
        'vi-VN' => 'Vietnamesisch (Vietnam)',
        'vun' => 'Vunjo',
        'vun-TZ' => 'Vunjo (Tansania)',
        'wae' => 'Walser-Dialekte',
        'wae-CH' => 'Walser-Dialekte (Schweiz)',
        'xog' => 'Soga',
        'xog-UG' => 'Soga (Uganda)',
        'yav' => 'Yangben',
        'yav-CM' => 'Yangben (Kamerun)',
        'yi' => 'Jiddisch',
        'yi-001' => 'Jiddisch (Welt)',
        'yo' => 'Yoruba',
        'yo-BJ' => 'Yoruba (Benin)',
        'yo-NG' => 'Yoruba (Nigeria)',
        'yue' => 'Kantonesisch',
        'yue-HK' => 'Kantonesisch (Sonderverwaltungszone Hongkong)',
        'zgh' => 'Tamazight',
        'zgh-MA' => 'Tamazight (Marokko)',
        'zh' => 'Chinesisch',
        'zh-Hans' => 'Chinesisch (Vereinfacht)',
        'zh-Hans-CN' => 'Chinesisch (Vereinfacht, China)',
        'zh-Hans-HK' => 'Chinesisch (Vereinfacht, Sonderverwaltungszone Hongkong)',
        'zh-Hans-MO' => 'Chinesisch (Vereinfacht, Sonderverwaltungsregion Macau)',
        'zh-Hans-SG' => 'Chinesisch (Vereinfacht, Singapur)',
        'zh-Hant' => 'Chinesisch (Traditionell)',
        'zh-Hant-HK' => 'Chinesisch (Traditionell, Sonderverwaltungszone Hongkong)',
        'zh-Hant-MO' => 'Chinesisch (Traditionell, Sonderverwaltungsregion Macau)',
        'zh-Hant-TW' => 'Chinesisch (Traditionell, Taiwan)',
        'zu' => 'Zulu',
        'zu-ZA' => 'Zulu (Südafrika)',
    ],
];
